"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SharedModule = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const user_entity_1 = require("./entities/user.entity");
const role_entity_1 = require("./entities/role.entity");
const task_entity_1 = require("./entities/task.entity");
const users_service_1 = require("./services/users.service");
const roles_service_1 = require("./services/roles.service");
const tasks_service_1 = require("./services/tasks.service");
const jwt_auth_guard_1 = require("./auth/jwt-auth.guard");
const jwt_1 = require("@nestjs/jwt");
const passport_1 = require("@nestjs/passport");
const config_1 = require("@nestjs/config");
const shared_controller_1 = require("./shared.controller");
const configuration_service_1 = require("./services/configuration.service");
const configuration_entity_1 = require("./entities/configuration.entity");
const forms_validations_entity_1 = require("./entities/forms-validations.entity");
const forms_validations_service_1 = require("./services/forms-validations.service");
const configuration_module_1 = require("../configuration/configuration.module");
const projects_module_1 = require("../projects/projects.module");
let SharedModule = class SharedModule {
};
exports.SharedModule = SharedModule;
exports.SharedModule = SharedModule = __decorate([
    (0, common_1.Module)({
        imports: [
            typeorm_1.TypeOrmModule.forFeature([user_entity_1.UserEntity, role_entity_1.RoleEntity, task_entity_1.TaskEntity, configuration_entity_1.ConfigurationEntity, forms_validations_entity_1.FormsValidationsEntity]),
            passport_1.PassportModule,
            configuration_module_1.ConfigurationModule,
            (0, common_1.forwardRef)(() => projects_module_1.ProjectsModule),
            jwt_1.JwtModule.registerAsync({
                imports: [config_1.ConfigModule],
                inject: [config_1.ConfigService],
                useFactory: async (configService) => ({
                    secret: configService.get('hashedPassword'),
                    signOptions: { expiresIn: '24h' },
                }),
            }),
        ],
        providers: [users_service_1.UserService, roles_service_1.RolesService, tasks_service_1.TaskService, jwt_auth_guard_1.JwtStrategy, configuration_service_1.ConfigurationService, forms_validations_service_1.FormsValidationsService],
        controllers: [shared_controller_1.SharedController],
        exports: [users_service_1.UserService, roles_service_1.RolesService, tasks_service_1.TaskService, configuration_service_1.ConfigurationService, forms_validations_service_1.FormsValidationsService],
    })
], SharedModule);
//# sourceMappingURL=shared.module.js.map