"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addGroupToWorksheet = void 0;
exports.fetchImageAsBase64 = fetchImageAsBase64;
exports.numberToColumnLetter = numberToColumnLetter;
const fs_1 = require("fs");
const path_1 = require("path");
async function fetchImageAsBase64(imagePath) {
    const filePath = (0, path_1.join)(__dirname, '..', '..', 'assets', imagePath);
    const imageBuffer = await fs_1.promises.readFile(filePath);
    return imageBuffer.toString('base64');
}
function numberToColumnLetter(num) {
    let columnLetter = '';
    while (num > 0) {
        let remainder = (num - 1) % 26;
        columnLetter = String.fromCharCode(65 + remainder) + columnLetter;
        num = Math.floor((num - 1) / 26);
    }
    return columnLetter;
}
const addGroupToWorksheet = (worksheet, group, startRow, endRow, rowsFields, startLine) => {
    const startCol = numberToColumnLetter(startRow);
    const endCol = numberToColumnLetter(endRow);
    const groupRange = `${startCol}${startLine}:${endCol}${startLine}`;
    worksheet.mergeCells(groupRange);
    worksheet.getCell(`${startCol}${startLine}`).value = group?.name;
    worksheet.getCell(`${startCol}${startLine}`).alignment = { horizontal: 'center' };
    const sortAtt = group.attributes.sort((a, b) => a.order - b.order);
    for (let i = 0; i < sortAtt.length; i++) {
        rowsFields.push({
            name: group.attributes[i].name,
            id: group.attributes[i].id,
        });
        const att = group.attributes[i];
        const col = numberToColumnLetter(startRow + i);
        const cell = worksheet.getCell(`${col}${startLine + 1}`);
        cell.value = att.name;
        cell.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: att?.color || group?.color } };
        cell.font = { color: { argb: 'FFFFFFFF' } };
        if (group?.name !== "") {
            worksheet.getCell(`${col}${startLine}`).fill = {
                type: 'pattern',
                pattern: 'solid',
                fgColor: { argb: group?.color }
            };
            worksheet.getCell(`${col}${startLine}`).font = { color: { argb: '0D0D0D' } };
        }
    }
};
exports.addGroupToWorksheet = addGroupToWorksheet;
//# sourceMappingURL=functions.js.map