import { ObjectCannedACL } from '@aws-sdk/client-s3';
import { ConfigService } from '@nestjs/config';
import { Readable } from 'stream';
export declare class S3Service {
    private readonly configService;
    private s3Client;
    private S3;
    constructor(configService: ConfigService);
    putObjectCommand(body: Readable | ReadableStream | Blob | string | Uint8Array | Buffer, contentType: string, folder: string, key: string, day?: number, acl?: ObjectCannedACL): Promise<string>;
    getSignedUrl(url: string): Promise<string>;
    deleteObjectCommand(urlOrKey: string): Promise<true | import("@aws-sdk/client-s3").DeleteObjectCommandOutput>;
    getObject(url: string): Promise<import("@aws-sdk/client-s3").GetObjectCommandOutput>;
    getCsvAsjson(url: string): Promise<unknown>;
    getSignedUrlForMediasManager(url: string): Promise<string>;
    getTotalOfRowsInCsv(url: string): Promise<number>;
    getStreamFile(url: string): Promise<import("@aws-sdk/client-s3").GetObjectCommandOutput>;
}
