"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3Service = void 0;
const client_s3_1 = require("@aws-sdk/client-s3");
const aws_sdk_1 = require("aws-sdk");
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const parse_1 = require("@fast-csv/parse");
let S3Service = class S3Service {
    constructor(configService) {
        this.configService = configService;
        this.s3Client = new client_s3_1.S3Client({
            region: this.configService.get('aws.region'),
        });
        this.S3 = new aws_sdk_1.S3({
            region: this.configService.get('aws.region'),
        });
    }
    async putObjectCommand(body, contentType, folder, key, day, acl) {
        if (this.configService.get('bypass.aws')) {
            return;
        }
        const bucket = this.configService.get('aws.bucket.name');
        const region = this.configService.get('aws.region');
        const environment = this.configService.get('aws.bucket.environment');
        const finalKey = `${environment}/${folder}/${key}`;
        let Expires = {};
        if (!!day) {
            const date = new Date();
            date.setDate(date.getDate() + day);
            Expires = { Expires: date };
        }
        let putObjectInput = {
            Bucket: bucket,
            ContentType: contentType,
            Key: finalKey,
            Body: body,
            ...Expires,
        };
        if (!!acl) {
            putObjectInput = {
                ACL: acl,
                ...putObjectInput,
            };
        }
        await this.s3Client.send(new client_s3_1.PutObjectCommand(putObjectInput));
        return finalKey;
    }
    async getSignedUrl(url) {
        const bucket = this.configService.get('aws.bucket.name');
        const region = this.configService.get('aws.region');
        const s3Domain = `https://${bucket}.s3.${region}.amazonaws.com/`;
        const key = url.replace(s3Domain, '');
        const params = {
            Bucket: this.configService.get(`aws.bucket.name`),
            Expires: 3000,
            Key: key,
        };
        try {
            const url = await this.S3.getSignedUrlPromise('getObject', params);
            return url;
        }
        catch (err) {
            console.error({ err });
            throw new Error(err);
        }
    }
    async deleteObjectCommand(urlOrKey) {
        try {
            if (urlOrKey) {
                const Bucket = this.configService.get('aws.bucket.name');
                const CloudFront = this.configService.get('aws.cloudfront.domain');
                const Key = urlOrKey
                    ?.replace(`https://${Bucket}.s3.amazonaws.com/`, '')
                    ?.replace(`${CloudFront}/`, '');
                if (Key === urlOrKey) {
                    return true;
                }
                const params = {
                    Bucket,
                    Key,
                };
                const result = await this.s3Client.send(new client_s3_1.DeleteObjectCommand(params));
                console.debug(`Delete file: ${urlOrKey} is done...`);
                return result;
            }
        }
        catch (err) {
            console.error({ err });
            throw new Error(err);
        }
    }
    async getObject(url) {
        const bucket = this.configService.get('aws.bucket.name');
        const region = this.configService.get('aws.region');
        const s3Domain = `https://${bucket}.s3.${region}.amazonaws.com/`;
        const key = url.replace(s3Domain, '');
        const params = {
            Bucket: this.configService.get(`aws.bucket.name`),
            Key: key,
        };
        try {
            const objectTransferData = await this.s3Client.send(new client_s3_1.GetObjectCommand(params));
            return objectTransferData;
        }
        catch (err) {
            console.error({ err });
            throw new Error(err);
        }
    }
    async getCsvAsjson(url) {
        return new Promise(async (res, rej) => {
            const bucket = this.configService.get('aws.bucket.name');
            const region = this.configService.get('aws.region');
            const s3Domain = `https://${bucket}.s3.${region}.amazonaws.com/`;
            const key = url.replace(s3Domain, '');
            const params = {
                Bucket: this.configService.get(`aws.bucket.name`),
                Key: key,
            };
            try {
                const objectTransferData = await this.s3Client.send(new client_s3_1.GetObjectCommand(params));
                const rows = [];
                (0, parse_1.parseStream)(objectTransferData.Body, {
                    headers: true,
                    delimiter: ';',
                    escape: '\\',
                    trim: true,
                })
                    .on('error', (error) => {
                    console.error(error);
                    rej(error);
                })
                    .on('data', (row) => {
                    rows.push(row);
                })
                    .on('end', () => {
                    res(rows);
                });
            }
            catch (err) {
                console.error({ err });
                throw new Error(err);
            }
        });
    }
    async getSignedUrlForMediasManager(url) {
        const bucket = this.configService.get('mediasManager.bucketName');
        const cdn = this.configService.get('mediasManager.cdnUrl');
        const key = url.replace(`${cdn}/`, '');
        const params = {
            Bucket: bucket,
            Expires: 3000,
            Key: key,
        };
        try {
            const url = await this.S3.getSignedUrlPromise('getObject', params);
            console.debug('[getSignedUrlForMediasManager] url => ', url);
            return url;
        }
        catch (err) {
            console.error({ err });
            throw new Error(err);
        }
    }
    async getTotalOfRowsInCsv(url) {
        const bucket = this.configService.get(`aws.bucket.name`);
        const region = this.configService.get('aws.region');
        const s3Domain = `https://${bucket}.s3.${region}.amazonaws.com/`;
        const key = url.replace(s3Domain, '');
        const input = {
            Bucket: bucket,
            Key: key,
            ExpressionType: 'SQL',
            Expression: 'SELECT Count(*) FROM s3object s',
            InputSerialization: {
                CSV: {
                    FileHeaderInfo: 'USE',
                    RecordDelimiter: '\n',
                    FieldDelimiter: ';',
                    AllowQuotedRecordDelimiter: true,
                },
            },
            OutputSerialization: {
                CSV: {},
            },
        };
        const command = new client_s3_1.SelectObjectContentCommand(input);
        const response = await this.s3Client.send(command);
        let totalLines;
        for await (const event of response.Payload) {
            const textDecoder = new TextDecoder();
            if (event?.Records) {
                const data = textDecoder.decode(event.Records.Payload).split('\n');
                totalLines = data[0];
            }
        }
        return totalLines;
    }
    async getStreamFile(url) {
        const bucket = this.configService.get(`aws.bucket.name`);
        const region = this.configService.get('aws.region');
        const s3Domain = `https://${bucket}.s3.${region}.amazonaws.com/`;
        const key = url.replace(s3Domain, '');
        const params = {
            Bucket: bucket,
            Expires: 3000,
            Key: key,
        };
        const command = new client_s3_1.GetObjectCommand(params);
        return this.s3Client.send(command);
    }
};
exports.S3Service = S3Service;
exports.S3Service = S3Service = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [config_1.ConfigService])
], S3Service);
//# sourceMappingURL=s3.service.js.map