"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsService = void 0;
const client_sqs_1 = require("@aws-sdk/client-sqs");
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
let SqsService = class SqsService {
    constructor(configService) {
        this.configService = configService;
        this.client = new client_sqs_1.SQSClient({
            region: this.configService.get('aws.region'),
        });
    }
    async sendMessageCommand(sqs, message, messageGroupId, messageDeduplicationId, messageAttributes) {
        if (this.configService.get('bypass.awsSqs')) {
            return;
        }
        if (messageGroupId !== undefined && messageGroupId !== null) {
            messageGroupId = messageGroupId
                ?.replace(/[^\w\s]/gi, '')
                .replace(/\s/g, '');
        }
        const params = {
            MessageBody: JSON.stringify(message),
            MessageGroupId: messageGroupId,
            QueueUrl: sqs,
            MessageDeduplicationId: messageDeduplicationId,
            MessageAttributes: messageAttributes,
        };
        return this.client.send(new client_sqs_1.SendMessageCommand(params));
    }
};
exports.SqsService = SqsService;
exports.SqsService = SqsService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [config_1.ConfigService])
], SqsService);
//# sourceMappingURL=sqs.service.js.map