"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isValidValue = void 0;
exports.validateAndConvertFraction = validateAndConvertFraction;
const isValidValue = (value) => {
    try {
        if (typeof value === 'string' && value === '') {
            return false;
        }
        if (typeof value === 'number' && isNaN(value)) {
            return false;
        }
        return true;
    }
    catch (error) {
        return false;
    }
};
exports.isValidValue = isValidValue;
function validateAndConvertFraction(value) {
    let fractionParts;
    if (value.includes('/')) {
        fractionParts = value.split('/');
    }
    else if (value.includes('de')) {
        fractionParts = value.toLowerCase().split('de');
    }
    else {
        return false;
    }
    if (fractionParts.length === 2) {
        const numerator = parseFloat(fractionParts[0].trim());
        const denominator = parseFloat(fractionParts[1].trim());
        if (!isNaN(numerator) && !isNaN(denominator) && denominator !== 0) {
            return numerator / denominator;
        }
    }
    return false;
}
//# sourceMappingURL=functions.js.map