"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getWorkbook = void 0;
const exceljs_1 = require("exceljs");
function numberToColumnLetter(num) {
    let columnLetter = '';
    while (num > 0) {
        let remainder = (num - 1) % 26;
        columnLetter = String.fromCharCode(65 + remainder) + columnLetter;
        num = Math.floor((num - 1) / 26);
    }
    return columnLetter;
}
const addGroupToWorksheet = (worksheet, group, startRow, endRow, rowsFields) => {
    const startCol = numberToColumnLetter(startRow);
    const endCol = numberToColumnLetter(endRow);
    const groupRange = `${startCol}1:${endCol}1`;
    worksheet.mergeCells(groupRange);
    worksheet.getCell(`${startCol}1`).value = group?.name;
    worksheet.getCell(`${startCol}1`).alignment = { horizontal: 'center' };
    const sortAtt = group.attributes.sort((a, b) => a.order - b.order);
    for (let i = 0; i < sortAtt.length; i++) {
        rowsFields.push({
            name: group.attributes[i].name,
            id: group.attributes[i].id,
        });
        const att = group.attributes[i];
        const col = numberToColumnLetter(startRow + i);
        const cell = worksheet.getCell(`${col}2`);
        cell.value = att.name;
        cell.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: group?.color } };
        cell.font = { color: { argb: 'FFFFFFFF' } };
        if (group?.name !== "") {
            worksheet.getCell(`${col}1`).fill = {
                type: 'pattern',
                pattern: 'solid',
                fgColor: { argb: group?.color }
            };
            worksheet.getCell(`${col}1`).font = { color: { argb: 'FFFFFFFF' } };
        }
    }
};
const getWorkbook = async (config, activities) => {
    const file = 'reporte.xlsx';
    const workbook = new exceljs_1.Workbook();
    const worksheet = workbook.addWorksheet('Reporte Campo');
    const sortHardAtt = config?.hardAttributes?.sort((a, b) => a.order - b.order);
    let startCol = 1;
    for (const att of sortHardAtt) {
        const col = numberToColumnLetter(startCol);
        const cell = worksheet.getCell(`${col}2`);
        cell.value = att?.name;
        cell.alignment = { horizontal: 'center' };
        cell.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: att?.color } };
        cell.font = { color: { argb: 'FFFFFFFF' } };
        startCol = startCol + 1;
    }
    const attGroupSorted = config?.attributesGroups.sort((a, b) => a.order - b.order);
    const rowsFields = [];
    for (const attg of attGroupSorted) {
        addGroupToWorksheet(worksheet, attg, startCol, startCol + attg.attributes.length - 1, rowsFields);
        startCol = startCol + attg.attributes.length;
    }
    const dataRows = [];
    for (const act of activities) {
        let startRowForData = 0;
        const col = numberToColumnLetter(startRowForData);
        let fecha = new Date(act?.createdAt)?.toISOString()?.split('T')[0];
        const row = {
            "Pozo": act?.location?.name,
            "Ingenieros": act?.realizado_por,
            "Fecha": fecha,
        };
        for (const field of rowsFields) {
            if (typeof (field?.name) === "string") {
                const value = act?.variablesValues.find((v) => v?.typeVariable?.id === field.id)?.value || "";
                row[field.name] = value;
            }
        }
        dataRows.push(row);
    }
    dataRows.forEach((row, index) => {
        const rowIndex = index + 3;
        for (const field of Object.keys(row)) {
            const col = numberToColumnLetter(Object.keys(row).indexOf(field) + 1);
            worksheet.getCell(`${col}${rowIndex}`).value = row[field];
        }
    });
    worksheet.eachRow({ includeEmpty: true }, (row) => {
        row.eachCell({ includeEmpty: true }, (cell) => {
            cell.border = {
                top: { style: 'thin' },
                left: { style: 'thin' },
                bottom: { style: 'thin' },
                right: { style: 'thin' }
            };
        });
    });
    return workbook;
};
exports.getWorkbook = getWorkbook;
//# sourceMappingURL=generateExcelReport.js.map